/*
 * Decompiled with CFR 0.152.
 */
package com.example.TornadoAlert95;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.json.JSONObject;

public class TornadoAlert95 {
    private static final String API_KEY = "df4f2ac31b932a79bbe7f80a4ed6bb8e";
    private static String location = null;
    private static final long startTime = System.currentTimeMillis();
    private static final List<String> scanLog = new ArrayList<String>();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("TornadoAlert95");
            ImageIcon icon = new ImageIcon("assets/tornado95.png");
            Image scaled = icon.getImage().getScaledInstance(100, 100, 4);
            JLabel logo = new JLabel(new ImageIcon(scaled));
            logo.setHorizontalAlignment(0);
            logo.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
            JTextArea console = new JTextArea();
            console.setEditable(false);
            console.setBackground(Color.BLACK);
            console.setForeground(Color.GREEN);
            console.setFont(new Font("Monospaced", 0, 14));
            JTextField input = new JTextField();
            input.setBackground(Color.BLACK);
            input.setForeground(Color.GREEN);
            input.setCaretColor(Color.GREEN);
            input.setFont(new Font("Monospaced", 0, 14));
            frame.setLayout(new BorderLayout());
            frame.add((Component)logo, "North");
            frame.add((Component)new JScrollPane(console), "Center");
            frame.add((Component)input, "South");
            frame.setSize(640, 400);
            frame.setDefaultCloseOperation(3);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            Timer blink = new Timer(500, new ActionListener(){
                private boolean on = true;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.on) {
                        jTextArea.append("_");
                    } else {
                        int n = jTextArea.getDocument().getLength();
                        if (n > 0) {
                            try {
                                jTextArea.getDocument().remove(n - 1, 1);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    this.on = !this.on;
                }
            });
            blink.start();
            console.append(">> LOADING: TORNADOALERT95 v3.6\n");
            console.append(">> ENTER STARTUP LOCATION (ZIP or city,COUNTRY) (e.g. 32284,US or Indianapolis,Indiana,US):\n> ");
            boolean[] initialized = new boolean[]{false};
            input.addActionListener(e -> {
                String command = input.getText().trim();
                String lower = command.toLowerCase();
                input.setText("");
                console.append("> " + command + "\n");
                if (!initialized[0]) {
                    if (!command.isEmpty()) {
                        location = command;
                        console.append(">> LOCATION SET TO: " + location + "\n");
                        console.append(">> TYPE 'help' FOR AVAILABLE COMMANDS\n");
                        initialized[0] = true;
                        return;
                    }
                    console.append(">> LOCATION CANNOT BE EMPTY. TRY AGAIN.\n> ");
                    return;
                }
                switch (lower) {
                    case "scan": {
                        console.append(">> INITIATING ATMOSPHERIC SCAN...\n");
                        Timer delay = new Timer(2000, evt2 -> {
                            String report = TornadoAlert95.fetchWeatherReport();
                            scanLog.add(report);
                            console.append(report);
                        });
                        delay.setRepeats(false);
                        delay.start();
                        break;
                    }
                    case "scan log": {
                        if (scanLog.isEmpty()) {
                            console.append(">> NO HISTORICAL SCANS AVAILABLE\n");
                            break;
                        }
                        console.append(">> HISTORICAL SCAN LOG:\n");
                        for (String entry : scanLog) {
                            console.append(entry + "\n");
                        }
                        break;
                    }
                    case "about": {
                        console.append(">> TornadoAlert95 v3.6\n>> CRT Weather Interface. SkyWatch Licensed.\n");
                        break;
                    }
                    case "help": {
                        console.append(">> AVAILABLE COMMANDS\n>> scan              - run weather scan\n>> scan log          - show scan history\n>> status            - show system status\n>> set location LOC  - e.g. set location 90210,US\n>> reload            - reboot radar modules\n>> update            - check for updates\n>> clear             - clear the screen\n>> uptime            - show run time\n>> theme invert      - toggle color scheme\n>> eject             - floppy disk\n>> godmode           - N/A\n>> the radar is lying - N/A\n>> exit              - shut down terminal\n");
                        break;
                    }
                    case "exit": {
                        console.append(">> TERMINAL SHUTTING DOWN... GOODBYE.\n");
                        Timer t = new Timer(1000, evt -> System.exit(0));
                        t.setRepeats(false);
                        t.start();
                        break;
                    }
                    case "godmode": {
                        console.append("GODMODE ACTIVATED. Weather can't touch you now.");
                        break;
                    }
                    case "the radar is lying": {
                        console.append("Nuh uh.");
                        break;
                    }
                    default: {
                        if (lower.startsWith("set location ")) {
                            String newLoc = command.substring(13).trim();
                            if (!newLoc.isEmpty()) {
                                location = newLoc;
                                console.append(">> LOCATION UPDATED TO: " + location + "\n");
                                break;
                            }
                            console.append(">> LOCATION UPDATE FAILED: NO INPUT DETECTED\n");
                            break;
                        }
                        console.append(">> UNKNOWN COMMAND: `" + command + "`\n>> TYPE `help` FOR OPTIONS\n");
                    }
                }
                console.setCaretPosition(console.getDocument().getLength());
            });
        });
    }

    private static String fetchWeatherReport() {
        try {
            String endpoint = "https://api.openweathermap.org/data/2.5/weather?q=" + location + "&units=imperial&appid=df4f2ac31b932a79bbe7f80a4ed6bb8e";
            JSONObject weather = new JSONObject(TornadoAlert95.readURL(endpoint));
            String city = weather.getString("name");
            String condition = weather.getJSONArray("weather").getJSONObject(0).getString("description").toUpperCase();
            JSONObject main = weather.getJSONObject("main");
            double temp = main.getDouble("temp");
            int humidity = main.getInt("humidity");
            double visibility = weather.has("visibility") ? weather.getDouble("visibility") / 1000.0 : -1.0;
            double wind = weather.getJSONObject("wind").getDouble("speed");
            double rain = 0.0;
            if (weather.has("rain")) {
                JSONObject rainData = weather.getJSONObject("rain");
                rain = rainData.has("1h") ? rainData.getDouble("1h") : (rainData.has("3h") ? rainData.getDouble("3h") : 0.0);
            }
            return String.format(">> ATMOSPHERIC SCAN COMPLETE\n>> LOCATION: %s (%s)\n>> CONDITION: %s\n>> TEMP: %.1f\u00b0F\n>> HUMIDITY: %d%%\n>> PRECIPITATION (1h): %.2f mm\n>> VISIBILITY: %.1f km\n>> WIND SPEED: %.1f mph\n>> RADAR STATUS: NOMINAL\n\n", location, city, condition, temp, humidity, rain, visibility, wind);
        }
        catch (Exception e) {
            return ">> SCAN FAILURE :: RADAR MODULE UNRESPONSIVE\n>> ERROR: " + e.getMessage() + "\n";
        }
    }

    private static String readURL(String endpoint) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(new URL(endpoint).openStream()));
        StringBuilder json = new StringBuilder();
        while ((line = in.readLine()) != null) {
            json.append(line);
        }
        in.close();
        return json.toString();
    }
}

