/*
 * Decompiled with CFR 0.152.
 */
package com.example.TornadoAlert95;

import com.example.TornadoAlert95.TornadoAlertGUI95;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class TornadoAlertGUI95
extends JFrame {
    private static final String API_KEY = "df4f2ac31b932a79bbe7f80a4ed6bb8e";
    private JLabel weatherIconLabel;
    private JLabel temperatureLabel;
    private JLabel conditionLabel;
    private JLabel locationLabel;
    private JTextField locationInputField;
    private JLabel humidityLabel;
    private JLabel windLabel;
    private JLabel visibilityLabel;
    private JLabel precipLabel;
    private JLabel statusBar;
    private JLabel timeLabel;
    private String currentLocation = "Enter location here... (e.g Detroit,US)";
    private final Timer refreshTimer = new Timer();

    public TornadoAlertGUI95() {
        Font pixelFont;
        this.setTitle("TornadoAlert95 \u2013 Weather");
        this.setDefaultCloseOperation(3);
        this.setSize(550, 500);
        this.setLocationRelativeTo(null);
        this.setLayout((LayoutManager)new BorderLayout(10, 10));
        Color bgColor = new Color(30, 30, 30);
        Color fgColor = Color.WHITE;
        Color borderColor = new Color(70, 70, 70);
        this.getContentPane().setBackground(bgColor);
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            pixelFont = Font.createFont(0, new File("assets/fonts/Pixelated.ttf"));
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(pixelFont);
            pixelFont = pixelFont.deriveFont(0, 12.0f);
        }
        catch (Exception e2) {
            System.err.println("Pixel font failed to load, using Monospaced fallback.");
            pixelFont = new Font("Monospaced", 0, 12);
        }
        JPanel locationInputPanel = new JPanel(new FlowLayout(0));
        locationInputPanel.setBackground(bgColor);
        locationInputPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(borderColor), "Set Location", 1, 2, pixelFont, fgColor));
        this.locationInputField = new JTextField(this.currentLocation, 20);
        this.locationInputField.setFont(pixelFont);
        this.locationInputField.setBackground(new Color(50, 50, 50));
        this.locationInputField.setForeground(fgColor);
        this.locationInputField.setCaretColor(fgColor);
        this.locationInputField.setBorder(BorderFactory.createLineBorder(borderColor));
        this.locationInputField.addActionListener(e -> {
            this.currentLocation = this.locationInputField.getText().trim();
            this.fetchWeather(this.currentLocation);
        });
        JLabel locLabel = new JLabel("City or ZIP,Country:");
        locLabel.setForeground(fgColor);
        locLabel.setFont(pixelFont);
        locationInputPanel.add(locLabel);
        locationInputPanel.add(this.locationInputField);
        this.weatherIconLabel = new JLabel();
        this.weatherIconLabel.setPreferredSize(new Dimension(160, 160));
        this.temperatureLabel = new JLabel("--\u00b0F");
        this.temperatureLabel.setFont(pixelFont.deriveFont(1, 28.0f));
        this.temperatureLabel.setForeground(fgColor);
        this.conditionLabel = new JLabel("CONDITION");
        this.conditionLabel.setFont(pixelFont.deriveFont(0, 16.0f));
        this.conditionLabel.setForeground(fgColor);
        this.locationLabel = new JLabel("LOCATION");
        this.locationLabel.setFont(pixelFont.deriveFont(0, 18.0f));
        this.locationLabel.setForeground(fgColor);
        this.timeLabel = new JLabel("Local Time: --:--");
        this.timeLabel.setFont(pixelFont.deriveFont(0, 12.0f));
        this.timeLabel.setForeground(fgColor);
        JPanel textStack = new JPanel();
        textStack.setBackground(bgColor);
        textStack.setLayout(new BoxLayout(textStack, 1));
        textStack.add(this.temperatureLabel);
        textStack.add(Box.createVerticalStrut(5));
        textStack.add(this.conditionLabel);
        textStack.add(Box.createVerticalStrut(5));
        textStack.add(this.locationLabel);
        textStack.add(Box.createVerticalStrut(5));
        textStack.add(this.timeLabel);
        JPanel forecastPanel = new JPanel(new FlowLayout(1, 30, 10));
        forecastPanel.setBackground(bgColor);
        forecastPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(borderColor), "Now", 1, 2, pixelFont, fgColor));
        forecastPanel.add(this.weatherIconLabel);
        forecastPanel.add(textStack);
        JPanel statsPanel = new JPanel();
        statsPanel.setBackground(bgColor);
        statsPanel.setLayout(new BoxLayout(statsPanel, 1));
        statsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(borderColor), "Details", 2, 2, pixelFont.deriveFont(1, 16.0f), fgColor));
        statsPanel.setAlignmentX(0.5f);
        this.humidityLabel = new JLabel("Humidity: --%");
        this.humidityLabel.setFont(pixelFont.deriveFont(0, 14.0f));
        this.humidityLabel.setForeground(fgColor);
        this.windLabel = new JLabel("Wind Speed: -- mph");
        this.windLabel.setFont(pixelFont.deriveFont(0, 14.0f));
        this.windLabel.setForeground(fgColor);
        this.visibilityLabel = new JLabel("Visibility: -- mi");
        this.visibilityLabel.setFont(pixelFont.deriveFont(0, 14.0f));
        this.visibilityLabel.setForeground(fgColor);
        this.precipLabel = new JLabel("Precipitation (1h): -- mm");
        this.precipLabel.setFont(pixelFont.deriveFont(0, 14.0f));
        this.precipLabel.setForeground(fgColor);
        this.humidityLabel.setAlignmentX(0.5f);
        this.windLabel.setAlignmentX(0.5f);
        this.visibilityLabel.setAlignmentX(0.5f);
        this.precipLabel.setAlignmentX(0.5f);
        statsPanel.add(this.humidityLabel);
        statsPanel.add(Box.createVerticalStrut(8));
        statsPanel.add(this.windLabel);
        statsPanel.add(Box.createVerticalStrut(8));
        statsPanel.add(this.visibilityLabel);
        statsPanel.add(Box.createVerticalStrut(8));
        statsPanel.add(this.precipLabel);
        this.statusBar = new JLabel("System ready.");
        this.statusBar.setFont(pixelFont.deriveFont(0, 10.0f));
        this.statusBar.setBorder(new BevelBorder(1));
        this.statusBar.setBackground(bgColor);
        this.statusBar.setForeground(fgColor);
        this.statusBar.setOpaque(true);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setBackground(bgColor);
        bottomPanel.add((Component)statsPanel, "Center");
        bottomPanel.add((Component)this.statusBar, "South");
        this.add((Component)locationInputPanel, (Object)"North");
        this.add((Component)forecastPanel, (Object)"Center");
        this.add((Component)bottomPanel, (Object)"South");
        this.fetchWeather(this.currentLocation);
        this.refreshTimer.scheduleAtFixedRate((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 60000L, 60000L);
        new javax.swing.Timer(60000, e -> {
            try {
                String[] parts = this.currentLocation.split(",", 2);
                String city = URLEncoder.encode(parts[0].trim(), "UTF-8");
                String country = parts.length > 1 ? parts[1].trim() : "US";
                String url = "https://api.openweathermap.org/data/2.5/weather?q=" + city + "," + country + "&appid=df4f2ac31b932a79bbe7f80a4ed6bb8e";
                JSONObject data = new JSONObject(TornadoAlertGUI95.readURL((String)url));
                int timezoneOffset = data.getInt("timezone");
                LocalDateTime now = LocalDateTime.now(ZoneOffset.ofTotalSeconds(timezoneOffset));
                String timeString = now.format(DateTimeFormatter.ofPattern("hh:mm a"));
                this.timeLabel.setText("Local Time: " + timeString);
            }
            catch (Exception ex) {
                this.timeLabel.setText("Local Time: --:--");
            }
        }).start();
        this.setVisible(true);
    }

    private void fetchWeather(String location) {
        this.temperatureLabel.setText("--\u00b0F");
        this.conditionLabel.setText("LOADING...");
        this.locationLabel.setText("");
        this.humidityLabel.setText("Humidity: --%");
        this.windLabel.setText("Wind Speed: -- mph");
        this.visibilityLabel.setText("Visibility: -- mi");
        this.precipLabel.setText("Precipitation (1h): -- mm");
        this.weatherIconLabel.setIcon(null);
        this.statusBar.setText("Fetching: " + location);
        2 worker = new /* Unavailable Anonymous Inner Class!! */;
        worker.execute();
    }

    private String mapConditionToIcon(String desc, boolean isNight) {
        desc = desc.toLowerCase();
        if (isNight) {
            if (desc.contains("thunderstorm")) {
                return "thunderstorm_night.png";
            }
            if (desc.contains("drizzle") || desc.contains("rain")) {
                return "rain_night.png";
            }
            if (desc.contains("snow") || desc.contains("sleet")) {
                return "mist_night.png";
            }
            if (desc.contains("mist") || desc.contains("haze") || desc.contains("fog") || desc.contains("smoke") || desc.contains("dust") || desc.contains("tornado")) {
                return "mist_night.png";
            }
            if (desc.equals("clear sky")) {
                return "clear_night.png";
            }
            if (desc.contains("cloud") || desc.contains("overcast")) {
                return "cloudy_night.png";
            }
            return "default_night.png";
        }
        if (desc.contains("thunderstorm")) {
            return "thunderstorm.png";
        }
        if (desc.contains("drizzle") || desc.contains("rain")) {
            return "rain.png";
        }
        if (desc.contains("snow") || desc.contains("sleet")) {
            return "snow.png";
        }
        if (desc.contains("mist") || desc.contains("haze") || desc.contains("fog") || desc.contains("smoke") || desc.contains("dust") || desc.contains("tornado")) {
            return "mist.png";
        }
        if (desc.equals("clear sky")) {
            return "clear_sky.png";
        }
        if (desc.contains("overcast")) {
            return "broken_clouds.png";
        }
        if (desc.contains("cloud")) {
            return "few_clouds.png";
        }
        return "default.png";
    }

    private static String readURL(String endpoint) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(new URL(endpoint).openStream()));
        StringBuilder json = new StringBuilder();
        while ((line = in.readLine()) != null) {
            json.append(line);
        }
        in.close();
        return json.toString();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(TornadoAlertGUI95::new);
    }
}

