/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.math.BigDecimal;
import java.math.BigInteger;

class NumberConversionUtil {
    NumberConversionUtil() {
    }

    static Number stringToNumber(String string) throws NumberFormatException {
        char c;
        String string2 = string;
        if (string2.startsWith(".")) {
            string2 = "0" + string2;
        }
        if (string2.startsWith("-.")) {
            string2 = "-0." + string2.substring(2);
        }
        if (NumberConversionUtil.isNumericChar(c = string2.charAt(0)) || c == '-') {
            BigInteger bigInteger;
            char c2;
            if (NumberConversionUtil.isDecimalNotation(string2)) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(string2);
                    if (c == '-' && BigDecimal.ZERO.compareTo(bigDecimal) == 0) {
                        return -0.0;
                    }
                    return bigDecimal;
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        Double d = Double.valueOf(string2);
                        if (d.isNaN() || d.isInfinite()) {
                            throw new NumberFormatException("val [" + string + "] is not a valid number.");
                        }
                        return d;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new NumberFormatException("val [" + string + "] is not a valid number.");
                    }
                }
            }
            string2 = NumberConversionUtil.removeLeadingZerosOfNumber(string);
            c = string2.charAt(0);
            if (c == '0' && string2.length() > 1) {
                c2 = string2.charAt(1);
                if (NumberConversionUtil.isNumericChar(c2)) {
                    throw new NumberFormatException("val [" + string + "] is not a valid number.");
                }
            } else if (c == '-' && string2.length() > 2) {
                c2 = string2.charAt(1);
                char c3 = string2.charAt(2);
                if (c2 == '0' && NumberConversionUtil.isNumericChar(c3)) {
                    throw new NumberFormatException("val [" + string + "] is not a valid number.");
                }
            }
            if ((bigInteger = new BigInteger(string2)).bitLength() <= 31) {
                return bigInteger.intValue();
            }
            if (bigInteger.bitLength() <= 63) {
                return bigInteger.longValue();
            }
            return bigInteger;
        }
        throw new NumberFormatException("val [" + string + "] is not a valid number.");
    }

    private static boolean isNumericChar(char c) {
        return c <= '9' && c >= '0';
    }

    static boolean potentialNumber(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        return NumberConversionUtil.potentialPositiveNumberStartingAtIndex(string, string.charAt(0) == '-' ? 1 : 0);
    }

    private static boolean isDecimalNotation(String string) {
        return string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1 || "-0".equals(string);
    }

    private static boolean potentialPositiveNumberStartingAtIndex(String string, int n) {
        if (n >= string.length()) {
            return false;
        }
        return NumberConversionUtil.digitAtIndex(string, string.charAt(n) == '.' ? n + 1 : n);
    }

    private static boolean digitAtIndex(String string, int n) {
        if (n >= string.length()) {
            return false;
        }
        return string.charAt(n) >= '0' && string.charAt(n) <= '9';
    }

    private static String removeLeadingZerosOfNumber(String string) {
        int n;
        if (string.equals("-")) {
            return string;
        }
        boolean bl = string.charAt(0) == '-';
        int n2 = n = bl ? 1 : 0;
        while (n < string.length()) {
            if (string.charAt(n) != '0') {
                if (bl) {
                    return "-".concat(string.substring(n));
                }
                return string.substring(n);
            }
            ++n;
        }
        if (bl) {
            return "-0";
        }
        return "0";
    }
}

