/*
 * Decompiled with CFR 0.152.
 */
package com.example.TornadoAlert95;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import org.json.JSONObject;

public class TornadoAlertGUI95
extends JFrame {
    private static final String API_KEY = "df4f2ac31b932a79bbe7f80a4ed6bb8e";
    private JLabel weatherIconLabel;
    private JLabel temperatureLabel;
    private JLabel conditionLabel;
    private JLabel locationLabel;
    private JTextField locationInputField;
    private JLabel humidityLabel;
    private JLabel windLabel;
    private JLabel visibilityLabel;
    private JLabel precipLabel;
    private JLabel statusBar;
    private JLabel timeLabel;
    private String currentLocation = "Enter location here... (e.g Detroit,US)";
    private final Timer refreshTimer = new Timer();

    public TornadoAlertGUI95() {
        Object object;
        Font font;
        Object object2;
        this.setTitle("TornadoAlert95 \u2013 Weather");
        this.setDefaultCloseOperation(3);
        this.setSize(550, 500);
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout(10, 10));
        Color color = new Color(30, 30, 30);
        Color color2 = Color.WHITE;
        Color color3 = new Color(70, 70, 70);
        this.getContentPane().setBackground(color);
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object2 = this.getClass().getResourceAsStream("/assets/fonts/Pixelated.ttf");
            try {
                if (object2 == null) {
                    throw new IOException("Font not found in JAR!");
                }
                font = Font.createFont(0, (InputStream)object2);
                object = GraphicsEnvironment.getLocalGraphicsEnvironment();
                ((GraphicsEnvironment)object).registerFont(font);
                font = font.deriveFont(0, 12.0f);
            }
            finally {
                if (object2 != null) {
                    ((InputStream)object2).close();
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Pixel font failed to load, using Monospaced fallback. " + exception.getMessage());
            font = new Font("Monospaced", 0, 12);
        }
        object2 = new JPanel(new FlowLayout(0));
        ((JComponent)object2).setBackground(color);
        ((JComponent)object2).setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(color3), "Set Location", 1, 2, font, color2));
        this.locationInputField = new JTextField(this.currentLocation, 20);
        this.locationInputField.setFont(font);
        this.locationInputField.setBackground(new Color(50, 50, 50));
        this.locationInputField.setForeground(color2);
        this.locationInputField.setCaretColor(color2);
        this.locationInputField.setBorder(BorderFactory.createLineBorder(color3));
        this.locationInputField.addActionListener(actionEvent -> {
            this.currentLocation = this.locationInputField.getText().trim();
            this.fetchWeather(this.currentLocation);
        });
        object = new JLabel("City or ZIP,Country:");
        ((JComponent)object).setForeground(color2);
        ((JComponent)object).setFont(font);
        ((Container)object2).add((Component)object);
        ((Container)object2).add(this.locationInputField);
        this.weatherIconLabel = new JLabel();
        this.weatherIconLabel.setPreferredSize(new Dimension(160, 160));
        this.temperatureLabel = new JLabel("--\u00b0F");
        this.temperatureLabel.setFont(font.deriveFont(1, 28.0f));
        this.temperatureLabel.setForeground(color2);
        this.conditionLabel = new JLabel("CONDITION");
        this.conditionLabel.setFont(font.deriveFont(0, 16.0f));
        this.conditionLabel.setForeground(color2);
        this.locationLabel = new JLabel("LOCATION");
        this.locationLabel.setFont(font.deriveFont(0, 18.0f));
        this.locationLabel.setForeground(color2);
        this.timeLabel = new JLabel("Local Time: --:--");
        this.timeLabel.setFont(font.deriveFont(0, 12.0f));
        this.timeLabel.setForeground(color2);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(color);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.temperatureLabel);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.conditionLabel);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.locationLabel);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.timeLabel);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 30, 10));
        jPanel2.setBackground(color);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(color3), "Now", 1, 2, font, color2));
        jPanel2.add(this.weatherIconLabel);
        jPanel2.add(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(color);
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(color3), "Details", 2, 2, font.deriveFont(1, 16.0f), color2));
        jPanel3.setAlignmentX(0.5f);
        this.humidityLabel = this.makeDetailLabel("Humidity: --%", font, color2);
        this.windLabel = this.makeDetailLabel("Wind Speed: -- mph", font, color2);
        this.visibilityLabel = this.makeDetailLabel("Visibility: -- mi", font, color2);
        this.precipLabel = this.makeDetailLabel("Precipitation (1h): -- mm", font, color2);
        jPanel3.add(this.humidityLabel);
        jPanel3.add(Box.createVerticalStrut(8));
        jPanel3.add(this.windLabel);
        jPanel3.add(Box.createVerticalStrut(8));
        jPanel3.add(this.visibilityLabel);
        jPanel3.add(Box.createVerticalStrut(8));
        jPanel3.add(this.precipLabel);
        this.statusBar = new JLabel("System ready.");
        this.statusBar.setFont(font.deriveFont(0, 10.0f));
        this.statusBar.setBorder(new BevelBorder(1));
        this.statusBar.setBackground(color);
        this.statusBar.setForeground(color2);
        this.statusBar.setOpaque(true);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBackground(color);
        jPanel4.add((Component)jPanel3, "Center");
        jPanel4.add((Component)this.statusBar, "South");
        this.add((Component)object2, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel4, "South");
        this.fetchWeather(this.currentLocation);
        this.refreshTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(() -> TornadoAlertGUI95.this.fetchWeather(TornadoAlertGUI95.this.currentLocation));
            }
        }, 60000L, 60000L);
        new javax.swing.Timer(60000, actionEvent -> this.updateLocalTime()).start();
        this.setVisible(true);
    }

    private JLabel makeDetailLabel(String string, Font font, Color color) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(font.deriveFont(0, 14.0f));
        jLabel.setForeground(color);
        jLabel.setAlignmentX(0.5f);
        return jLabel;
    }

    private void fetchWeather(final String string) {
        this.temperatureLabel.setText("--\u00b0F");
        this.conditionLabel.setText("LOADING...");
        this.locationLabel.setText("");
        this.humidityLabel.setText("Humidity: --%");
        this.windLabel.setText("Wind Speed: -- mph");
        this.visibilityLabel.setText("Visibility: -- mi");
        this.precipLabel.setText("Precipitation (1h): -- mm");
        this.weatherIconLabel.setIcon(null);
        this.statusBar.setText("Fetching: " + string);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() {
                try {
                    String[] stringArray = string.split(",", 2);
                    String string8 = URLEncoder.encode(stringArray[0].trim(), "UTF-8");
                    String string2 = stringArray.length > 1 ? stringArray[1].trim() : "US";
                    String string3 = "https://api.openweathermap.org/data/2.5/weather?q=" + string8 + "," + string2 + "&appid=df4f2ac31b932a79bbe7f80a4ed6bb8e&units=imperial";
                    JSONObject jSONObject = new JSONObject(TornadoAlertGUI95.readURL(string3));
                    String string4 = jSONObject.getString("name");
                    JSONObject jSONObject2 = jSONObject.getJSONObject("main");
                    double d = jSONObject2.getDouble("temp");
                    int n = jSONObject2.getInt("humidity");
                    double d2 = jSONObject.getJSONObject("wind").getDouble("speed");
                    int n2 = jSONObject.has("visibility") ? jSONObject.getInt("visibility") : -1;
                    double d3 = jSONObject.has("rain") ? jSONObject.getJSONObject("rain").optDouble("1h", 0.0) : 0.0;
                    String string5 = jSONObject.getJSONArray("weather").getJSONObject(0).getString("description");
                    TornadoAlertGUI95.this.temperatureLabel.setText(String.format("%.0f\u00b0F", d));
                    TornadoAlertGUI95.this.conditionLabel.setText(string5.toUpperCase());
                    TornadoAlertGUI95.this.locationLabel.setText(string4);
                    TornadoAlertGUI95.this.humidityLabel.setText("Humidity: " + n + "%");
                    TornadoAlertGUI95.this.windLabel.setText(String.format("Wind Speed: %.1f mph", d2));
                    TornadoAlertGUI95.this.visibilityLabel.setText(n2 >= 0 ? String.format("Visibility: %.1f mi", (double)n2 / 1609.34) : "Visibility: N/A");
                    TornadoAlertGUI95.this.precipLabel.setText(String.format("Precipitation (1h): %.2f mm", d3));
                    int n3 = jSONObject.getInt("timezone");
                    LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.ofTotalSeconds(n3));
                    String string6 = localDateTime.format(DateTimeFormatter.ofPattern("hh:mm a"));
                    TornadoAlertGUI95.this.timeLabel.setText("Local Time: " + string6);
                    boolean bl = localDateTime.getHour() >= 20 || localDateTime.getHour() < 6;
                    String string7 = TornadoAlertGUI95.this.mapConditionToIcon(string5, bl);
                    URL uRL = this.getClass().getResource("/assets/" + string7);
                    if (uRL != null) {
                        ImageIcon imageIcon = new ImageIcon(uRL);
                        Image image = imageIcon.getImage().getScaledInstance(160, 160, 4);
                        TornadoAlertGUI95.this.weatherIconLabel.setIcon(new ImageIcon(image));
                    } else {
                        System.err.println("Missing icon: " + string7);
                    }
                }
                catch (Exception exception) {
                    TornadoAlertGUI95.this.conditionLabel.setText("ERROR");
                    TornadoAlertGUI95.this.locationLabel.setText("Invalid location");
                    TornadoAlertGUI95.this.humidityLabel.setText("Humidity: --%");
                    TornadoAlertGUI95.this.windLabel.setText("Wind Speed: -- mph");
                    TornadoAlertGUI95.this.visibilityLabel.setText("Visibility: -- mi");
                    TornadoAlertGUI95.this.precipLabel.setText("Precipitation (1h): -- mm");
                    TornadoAlertGUI95.this.timeLabel.setText("Time: --:--");
                    System.err.println("Weather fetch failed: " + exception.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                TornadoAlertGUI95.this.statusBar.setText("Last updated: " + TornadoAlertGUI95.this.currentLocation);
            }
        };
        swingWorker.execute();
    }

    private void updateLocalTime() {
        try {
            String[] stringArray = this.currentLocation.split(",", 2);
            String string = URLEncoder.encode(stringArray[0].trim(), "UTF-8");
            String string2 = stringArray.length > 1 ? stringArray[1].trim() : "US";
            String string3 = "https://api.openweathermap.org/data/2.5/weather?q=" + string + "," + string2 + "&appid=df4f2ac31b932a79bbe7f80a4ed6bb8e";
            JSONObject jSONObject = new JSONObject(TornadoAlertGUI95.readURL(string3));
            int n = jSONObject.getInt("timezone");
            LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.ofTotalSeconds(n));
            String string4 = localDateTime.format(DateTimeFormatter.ofPattern("hh:mm a"));
            this.timeLabel.setText("Local Time: " + string4);
        }
        catch (Exception exception) {
            this.timeLabel.setText("Local Time: --:--");
        }
    }

    private String mapConditionToIcon(String string, boolean bl) {
        string = string.toLowerCase();
        if (bl) {
            if (string.contains("thunderstorm")) {
                return "thunderstorm_night.png";
            }
            if (string.contains("drizzle") || string.contains("rain")) {
                return "rain_night.png";
            }
            if (string.contains("snow") || string.contains("sleet")) {
                return "mist_night.png";
            }
            if (string.contains("mist") || string.contains("haze") || string.contains("fog") || string.contains("smoke") || string.contains("dust") || string.contains("tornado")) {
                return "mist_night.png";
            }
            if (string.equals("clear sky")) {
                return "clear_night.png";
            }
            if (string.contains("cloud") || string.contains("overcast")) {
                return "cloudy_night.png";
            }
            return "default_night.png";
        }
        if (string.contains("thunderstorm")) {
            return "thunderstorm.png";
        }
        if (string.contains("drizzle") || string.contains("rain")) {
            return "rain.png";
        }
        if (string.contains("snow") || string.contains("sleet")) {
            return "snow.png";
        }
        if (string.contains("mist") || string.contains("haze") || string.contains("fog") || string.contains("smoke") || string.contains("dust") || string.contains("tornado")) {
            return "mist.png";
        }
        if (string.equals("clear sky")) {
            return "clear_sky.png";
        }
        if (string.contains("overcast")) {
            return "broken_clouds.png";
        }
        if (string.contains("cloud")) {
            return "few_clouds.png";
        }
        return "default.png";
    }

    private static String readURL(String string) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new URL(string).openStream()));){
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
            String string3 = stringBuilder.toString();
            return string3;
        }
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(TornadoAlertGUI95::new);
    }
}

